﻿<?LassoScript
/*
This demo illustrates how to place an image of unknown size and still keep it 
within a given boundary.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/

//First set some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype, -nocompress));

// Set some basic vars
var('imginfo'= null,
	'height' = integer,
	'width' = integer,
	'factor' = decimal);

/*
We want the image placed within a "box" that's 200 X 200 pixels. 
But we don't know the original size of the image or if it's 
portrait or landscape oriented. The pdf is to be printed using 150 LPI 
so we need to reduce the original image with at least a factor 0.24. 
*/

if(file_exists( 'largeballwide.gif'));
	$imginfo = image( 'largeballwide.gif', -info);
	$height = $imginfo -> height;
	$width = $imginfo -> width;

	// Find the size factor to use. If the image is to small for chosen print 
	// quality use standard factor for 150 LPI (0.24).
	// Since we don't know the orientation of the image we use the largest one 
	// of the height and width
	$factor = 200.0 / decimal( math_max( $width, $height));
	(($factor > 0.24) ? ($factor = 0.24));

	var('image' = pdf_image(
		-file = 'largeballwide.gif')); // Original image 634 X 964 pixels

	// Place the image within the "box".
	$pdf -> add( $image,
		-height = $height * $factor,
		-width = $width * $factor,
		-left = 100,
		-top = 250
		);

	var('text' = PDF_text( 'Image data\rheight: ' + $height + 
			' width: ' + $width + ' factor: ' + $factor ));

	// Place info text about the image
	$pdf -> add( $text,
		-width = 300,
		-left = 100,
		-top = 250,
		-leading = 16);

	// Place a rectangle to show the "box" we want the image to stay within.
	// Rectangles are drawn with coordinates (X, Y, Width, Height) 
	// starting from the lower left of the page.
	$pdf -> Rect( 100, $pageheight - 250, 200, 200); 
/if;

// Let's do it again with another image this time portrait oriented
if(file_exists( 'largeballtall.gif'));
	$imginfo = image( 'largeballtall.gif', -info);
	$height = $imginfo -> height;
	$width = $imginfo -> width;

	$factor = 200.0 / decimal( math_max( $width, $height));
	(($factor > 0.24) ? ($factor = 0.24));

	var('image' = pdf_image(
		-file = 'largeballtall.gif')); // Original image 964 X 634 pixels

	$pdf -> add( $image,
		-height = $height * $factor,
		-width = $width * $factor,
		-left = 100,
		-top = 500
		);

	var('text' = PDF_text( 'Image data\rheight: ' + $height + 
			' width: ' + $width + ' factor: ' + $factor ));

	$pdf -> add( $text,
		-width = 300,
		-left = 100,
		-top = 500,
		-leading = 16);

	$pdf -> Rect( 100, $pageheight - 500, 200, 200);
/if;


// Let's do it a final time now with an image that's to small for the "box"
if(file_exists( 'ball.gif'));
	$imginfo = image( 'ball.gif', -info);
	$height = $imginfo -> height;
	$width = $imginfo -> width;

	$factor = 200.0 / decimal( math_max( $width, $height));
	(($factor > 0.24) ? ($factor = 0.24));

	var('image' = pdf_image(
		-file = 'ball.gif')); // Original image 964 X 634 pixels

	$pdf -> add( $image,
		-height = $height * $factor,
		-width = $width * $factor,
		-left = 100,
		-top = 750
		);

	var('text' = PDF_text( 'Image data\rheight: ' + $height + 
	' width: ' + $width + ' factor: ' + $factor ));

	$pdf -> add( $text,
		-width = 300,
		-left = 100,
		-top = 750,
		-leading = 16);

	$pdf -> Rect( 100, $pageheight - 750, 200, 200);
/if;

// Finally close the pdf_doc and serve it
$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo3.pdf');

?>